/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.wishingforsunshine.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import noobanidus.libs.repack_wishingforsunshine.noobutil.util.ItemUtil;
import noobanidus.mods.wishingforsunshine.config.ItemType;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec COMMON_CONFIG;
    private static Map<ItemType, ForgeConfigSpec.ConfigValue<String>> MAP;
    private static Map<ItemType, String> DEFAULTS;
    private static Map<ItemType, ItemStack> CACHE;
    public static ForgeConfigSpec.DoubleValue VILLAGE_CHANCE;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static ItemStack getItemForType(ItemType type) {
        ItemStack cachedItem = CACHE.get((Object)type);
        if (cachedItem == null) {
            String def = (String)MAP.get((Object)type).get();
            cachedItem = ConfigManager.getItem(def);
            CACHE.put(type, cachedItem);
        }
        return cachedItem;
    }

    @Nullable
    public static ItemType getTypeForItem(ItemStack item) {
        for (ItemType type : ItemType.values()) {
            ItemStack forType = ConfigManager.getItemForType(type);
            if (!ItemUtil.equalWithoutSize(forType, item)) continue;
            return type;
        }
        return null;
    }

    @Nullable
    private static ItemStack getItem(String name) {
        ResourceLocation rl = new ResourceLocation(name);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(rl);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item);
    }

    static {
        MAP = new HashMap<ItemType, ForgeConfigSpec.ConfigValue<String>>();
        DEFAULTS = new HashMap<ItemType, String>();
        CACHE = new HashMap<ItemType, ItemStack>();
        DEFAULTS.put(ItemType.RAIN, Objects.requireNonNull(Items.field_221621_aW.getRegistryName()).toString());
        DEFAULTS.put(ItemType.SUNSHINE, Objects.requireNonNull(Items.field_221908_fl.getRegistryName()).toString());
        DEFAULTS.put(ItemType.SUNSET, Objects.requireNonNull(Items.field_151042_j.getRegistryName()).toString());
        DEFAULTS.put(ItemType.SUNRISE, Objects.requireNonNull(Items.field_151043_k.getRegistryName()).toString());
        for (ItemType type : ItemType.values()) {
            String def = DEFAULTS.getOrDefault((Object)type, "");
            MAP.put(type, (ForgeConfigSpec.ConfigValue<String>)COMMON_BUILDER.comment("Item to trigger the " + type.name().toLowerCase() + " effect (registry name, leave blank for no default)").define(type.name().toLowerCase(), (Object)def));
        }
        VILLAGE_CHANCE = COMMON_BUILDER.defineInRange("village_chance", 0.2, 0.0, 1.0);
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

